""" Constants and Python-version-compatibility fixes to be imported into
    implementations' global scopes.
"""

# Make a boolean type available if we haven't got one. (Python <2.2.1)
#
try:
  True
except NameError:
  globals()['True'], globals()['False']= None is None, None is not None

# Exceptions to avoid catching in catch-all try statements.
#
NonErrors= (KeyboardInterrupt, SystemExit, SystemError, MemoryError)

# Make a dummy type to test against when there's no Unicode (Python <1.6);
# in Python 1.6 all unicode strings must be converted to plain strings before
# executing; in Python 2.0 up this happens automatically; Python 2.3 up can
# execute Unicode strings without conversion.
#
import types
try:
  UnicodeType= types.UnicodeType
  StringTypes= (types.StringType, types.UnicodeType)
  try:
    exec unicode('pass #')+unichr(262)
    convertExecs= False
  except Exception:
    convertExecs= True
except AttributeError:
  UnicodeType= None
  StringTypes= (types.StringType,)
  convertExecs= False
IntTypes= (types.IntType, types.LongType)

# Make a dummy featureless module when there's no __future__. (Python <2.1)
#
try:
  import __future__
  future__mod= __future__
except ImportError:
  class future__mod:
    pass

# Make isinstance support tuple as second parameter. (Python <2.3)
#
try:
  isinstance('', (types.StringType,))
except TypeError:
  __isinstance= isinstance
  def _isinstance(inst, ts):
    if type(ts)!=types.TupleType:
      return __isinstance(inst, ts)
    for t in ts:
      if __isinstance(inst, t):
        return True
    return False
  globals()['isinstance']= _isinstance

# Get string buffer, using the C version if available (but don't use it on
# Python 1.6 or 2.0 where it doesn't support unicode). See whether we need to
# provide our own StringIO.truncate() method. (We always do with cStringIO -
# although the method exists there, it is broken; we sometimes do with plain
# StringIO, dependent on Python version.)
#
try:
  from cStringIO import StringIO
  if UnicodeType is not None:
    StringIO().write(unichr(256))
except (ImportError, SystemError, UnicodeError):
  from StringIO import StringIO
  canTruncate= hasattr(StringIO, 'truncate')
else:
  canTruncate= False

# Make a truncatable StringIO if we don't have one already.
#
if canTruncate:
  TrunkIO= StringIO
else:
  class TrunkIO:
    def __init__(self):
      self.delegate= StringIO()
    def write(self, s):
      self.delegate.write(s)
    def getvalue(self):
      return self.delegate.getvalue()
    def truncate(self, size):
      delegate= StringIO()
      if size>0:
        delegate.write(self.delegate.getvalue()[:size])
      self.delegate= delegate


# Get path to error page template.
#
import imp, os
ERROR_PAGE= os.path.join(imp.find_module('pxtl')[1], '__error__.px')

# Namespaces that PXTL has to be aware of.
#
PXNS= 'http://www.doxdesk.com/pxtl'
HTNS= 'http://www.w3.org/1999/xhtml'
XMNS= 'http://www.w3.org/XML/1998/namespace'
NSNS= 'http://www.w3.org/2000/xmlns/'

# MIME types with significance to PXTL.
#
TYPES_PXTL= ['text/x.pxtl+xml', 'text/pxtl+xml']
TYPES_TEXT= ['text/plain']
TYPES_XML= [
  'text/html', 'application/xhtml+xml',
  'text/xml', 'application/xml', 'text/xsl',
  'text/xml-external-parsed-entity', 'application/xml-external-parsed-entity'
]

# Make sure mimetypes knows .px files; urllib will need to ask it later.
#
import mimetypes
if not mimetypes.types_map.has_key('.px'):
  mimetypes.types_map['.px']= TYPES_PXTL[0]

# Convenience lists of defined names.
#
CODINGS= ['text', 'upar', 'cstr', 'jstr', 'name']
TARGETS= CODINGS+['code', 'note', 'mark']
PSEUDOS= CODINGS+['code', 'note', 'if']
SHORTCUTS= { '_': 'text', '__': 'note', 'px': 'code' }
CONDITIONALS= ['if', 'orif', 'anif', 'elif', 'else']
PRECONDITIONALS= ['if', 'orif', 'anif', 'elif', 'for', 'while']
ATTRIBUTES= CONDITIONALS+['tagname', 'attr', 'space', 'doctype', 'future']

# Modules put here for generated template code from the optimised
# implementation to access easily, as it can't pollute the script's own global
# scope by importing them there, and import-as isn't backwards-compatible.
# Similiarly, keep a reference to some real builtins so we can access them in
# the case where a perverse template assigns somthing else to them.
#
import sys, string, urllib, urlparse
none, str, xrange, type= None, str, xrange, type
