import os, sys, string, traceback
from pxtl import reference, optimised, fixdom


dom= None
if len(sys.argv)>=2:
  dom= fixdom.getImplementation(sys.argv[1])


def testImplementation(imp, name):
  diffs= []
  for test in os.listdir('templates'):
    template= os.path.abspath(os.path.join('templates', test))
    output= os.path.join('results-'+name, os.path.splitext(test)[0]+'.out')
    correct= os.path.join('results', os.path.splitext(test)[0]+'.out')
    writer= open(output, 'wb')
    try:
      imp.processFile(template, writer, dom= dom, bytecodebase= None)
    except KeyboardInterrupt:
      raise
    except:
      writer.write('-'*80+'\n')
      traceback.print_exc(file= writer)
    writer.close()

    f= open(output, 'rb')
    actual= f.read()
    f.close()
    f= open(correct, 'rb')
    expected= f.read()
    f.close()
    if actual!=expected:
      diffs.append(test)

  print 'pxtl.%s:' % name
  if diffs==[]:
    print 'ALL PASSED'
  else:
    print 'FAILED:'
    print string.join(map(lambda d: '  %s\n' % d, diffs), '')


testImplementation(reference, 'reference')
testImplementation(optimised, 'optimised')
